<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('role_id')->unsigned();
			$table->datetime('naissance');
			$table->string('firstname', 20);
			$table->string('surname', 20);
			$table->string('nickname', 20);
			$table->string('email', 50);
			$table->smallInteger('cp');
			$table->string('adress', 50);
			$table->string('tel', 25);
			$table->datetime('coti');
			$table->smallInteger('reputation');
			$table->boolean('notifications_messages');
			$table->boolean('notifications_comments');
			$table->boolean('notifications');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}