<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('comments_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_posts', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_posts', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('roles_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_tags', function(Blueprint $table) {
			$table->foreign('tags_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_tags', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_categories', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_categories', function(Blueprint $table) {
			$table->foreign('pcategories_id')->references('id')->on('pcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('objects_colors', function(Blueprint $table) {
			$table->foreign('objects_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('objects_colors', function(Blueprint $table) {
			$table->foreign('colors_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('objects_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('fournisseurs_id')->references('id')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wishes', function(Blueprint $table) {
			$table->foreign('oWishes_id')->references('id')->on('oWishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('canNotifs', function(Blueprint $table) {
			$table->foreign('notifications_id')->references('id')->on('notifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('objects_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales_users', function(Blueprint $table) {
			$table->foreign('sales_id')->references('id')->on('sales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales_users', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('objects_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories_subcategories', function(Blueprint $table) {
			$table->foreign('subcategories_id')->references('id')->on('subcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories_subcategories', function(Blueprint $table) {
			$table->foreign('categories_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ocategories', function(Blueprint $table) {
			$table->foreign('objects_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ocategories', function(Blueprint $table) {
			$table->foreign('categories_subcategories_id')->references('id')->on('categories_subcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_posts_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_comments_id_foreign');
		});
		Schema::table('users_posts', function(Blueprint $table) {
			$table->dropForeign('users_posts_users_id_foreign');
		});
		Schema::table('users_posts', function(Blueprint $table) {
			$table->dropForeign('users_posts_posts_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_roles_id_foreign');
		});
		Schema::table('posts_tags', function(Blueprint $table) {
			$table->dropForeign('posts_tags_tags_id_foreign');
		});
		Schema::table('posts_tags', function(Blueprint $table) {
			$table->dropForeign('posts_tags_posts_id_foreign');
		});
		Schema::table('posts_categories', function(Blueprint $table) {
			$table->dropForeign('posts_categories_posts_id_foreign');
		});
		Schema::table('posts_categories', function(Blueprint $table) {
			$table->dropForeign('posts_categories_pcategories_id_foreign');
		});
		Schema::table('objects_colors', function(Blueprint $table) {
			$table->dropForeign('objects_colors_objects_id_foreign');
		});
		Schema::table('objects_colors', function(Blueprint $table) {
			$table->dropForeign('objects_colors_colors_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_objects_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_fournisseurs_id_foreign');
		});
		Schema::table('wishes', function(Blueprint $table) {
			$table->dropForeign('wishes_oWishes_id_foreign');
		});
		Schema::table('canNotifs', function(Blueprint $table) {
			$table->dropForeign('canNotifs_notifications_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_objects_id_foreign');
		});
		Schema::table('sales_users', function(Blueprint $table) {
			$table->dropForeign('sales_users_sales_id_foreign');
		});
		Schema::table('sales_users', function(Blueprint $table) {
			$table->dropForeign('sales_users_users_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_users_id_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_objects_id_foreign');
		});
		Schema::table('categories_subcategories', function(Blueprint $table) {
			$table->dropForeign('categories_subcategories_subcategories_id_foreign');
		});
		Schema::table('categories_subcategories', function(Blueprint $table) {
			$table->dropForeign('categories_subcategories_categories_id_foreign');
		});
		Schema::table('ocategories', function(Blueprint $table) {
			$table->dropForeign('ocategories_objects_id_foreign');
		});
		Schema::table('ocategories', function(Blueprint $table) {
			$table->dropForeign('ocategories_categories_subcategories_id_foreign');
		});
	}
}