<?php

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	public function wishes()
	{
		return $this->morphedByMany('Wishe', 'canNotif');
	}

	public function object_notification()
	{
		return $this->morphedByMany('Object_notification', 'canNotif');
	}

	public function search_notification()
	{
		return $this->morphedByMany('Search_notification', 'canNotif');
	}

	public function user()
	{
		return $this->belongsToMany('User');
	}

	public function messages()
	{
		return $this->morphedByMany('Message', 'canNotif');
	}

}