<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone', 191)->unique();
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->string('country_code', 191)->nullable();
			$table->tinyInteger('type')->default('1');
			$table->string('image', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}