<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_translations', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('disabled_service_translations', function(Blueprint $table) {
			$table->foreign('disabled_service_id')->references('id')->on('disabled_services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mosques', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('mosque_translations', function(Blueprint $table) {
			$table->foreign('mosque_id')->references('id')->on('mosques')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mosque_images', function(Blueprint $table) {
			$table->foreign('mosque_id')->references('id')->on('mosques')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mosque_services', function(Blueprint $table) {
			$table->foreign('mosque_id')->references('id')->on('mosques')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mosque_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('mosque_disabled_services', function(Blueprint $table) {
			$table->foreign('mosque_id')->references('id')->on('mosques')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mosque_disabled_services', function(Blueprint $table) {
			$table->foreign('disabled_service_id')->references('id')->on('disabled_services')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('interest_trasnlations', function(Blueprint $table) {
			$table->foreign('interest_id')->references('id')->on('intrestes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('mosque_id')->references('id')->on('mosques')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('privacy_trasnlsations', function(Blueprint $table) {
			$table->foreign('privacy_id')->references('id')->on('privacies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('condition_translations', function(Blueprint $table) {
			$table->foreign('condition_id')->references('id')->on('conditions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('common_question_translations', function(Blueprint $table) {
			$table->foreign('common_question_id')->references('id')->on('common_questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('azkars', function(Blueprint $table) {
			$table->foreign('azkar_category_id')->references('id')->on('azkar_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('user_devices', function(Blueprint $table) {
			$table->dropForeign('user_devices_user_id_foreign');
		});
		Schema::table('service_translations', function(Blueprint $table) {
			$table->dropForeign('service_translations_service_id_foreign');
		});
		Schema::table('disabled_service_translations', function(Blueprint $table) {
			$table->dropForeign('disabled_service_translations_disabled_service_id_foreign');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->dropForeign('country_translations_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->dropForeign('city_translations_city_id_foreign');
		});
		Schema::table('mosques', function(Blueprint $table) {
			$table->dropForeign('mosques_user_id_foreign');
		});
		Schema::table('mosque_translations', function(Blueprint $table) {
			$table->dropForeign('mosque_translations_mosque_id_foreign');
		});
		Schema::table('mosque_images', function(Blueprint $table) {
			$table->dropForeign('mosque_images_mosque_id_foreign');
		});
		Schema::table('mosque_services', function(Blueprint $table) {
			$table->dropForeign('mosque_services_mosque_id_foreign');
		});
		Schema::table('mosque_services', function(Blueprint $table) {
			$table->dropForeign('mosque_services_service_id_foreign');
		});
		Schema::table('mosque_disabled_services', function(Blueprint $table) {
			$table->dropForeign('mosque_disabled_services_mosque_id_foreign');
		});
		Schema::table('mosque_disabled_services', function(Blueprint $table) {
			$table->dropForeign('mosque_disabled_services_disabled_service_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_country_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_city_id_foreign');
		});
		Schema::table('interest_trasnlations', function(Blueprint $table) {
			$table->dropForeign('interest_trasnlations_interest_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_user_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_mosque_id_foreign');
		});
		Schema::table('privacy_trasnlsations', function(Blueprint $table) {
			$table->dropForeign('privacy_trasnlsations_privacy_id_foreign');
		});
		Schema::table('condition_translations', function(Blueprint $table) {
			$table->dropForeign('condition_translations_condition_id_foreign');
		});
		Schema::table('common_question_translations', function(Blueprint $table) {
			$table->dropForeign('common_question_translations_common_question_id_foreign');
		});
		Schema::table('azkars', function(Blueprint $table) {
			$table->dropForeign('azkars_azkar_category_id_foreign');
		});
	}
}