<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('id_customer')->references('id_customer')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('id_car')->references('id_car')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('back_cars', function(Blueprint $table) {
			$table->foreign('id_contract')->references('id_contract')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Penalizations', function(Blueprint $table) {
			$table->foreign('id_contract')->references('id_contract')->on('back_cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_repairs', function(Blueprint $table) {
			$table->foreign('id_car')->references('id_car')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_documents', function(Blueprint $table) {
			$table->foreign('id_car')->references('id_car')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_id_customer_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_id_car_foreign');
		});
		Schema::table('back_cars', function(Blueprint $table) {
			$table->dropForeign('back_cars_id_contract_foreign');
		});
		Schema::table('Penalizations', function(Blueprint $table) {
			$table->dropForeign('Penalizations_id_contract_foreign');
		});
		Schema::table('car_repairs', function(Blueprint $table) {
			$table->dropForeign('car_repairs_id_car_foreign');
		});
		Schema::table('car_documents', function(Blueprint $table) {
			$table->dropForeign('car_documents_id_car_foreign');
		});
	}
}