<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function thread()
	{
		return $this->belongsTo('Thread');
	}

	public function polls()
	{
		return $this->hasMany('Poll');
	}

}