<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMachinesTable extends Migration {

	public function up()
	{
		Schema::create('machines', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('station_id')->unsigned();
			$table->bigInteger('status_id')->unsigned();
			$table->integer('inputs');
			$table->integer('outputs');
			$table->integer('pump_on_time');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('machines');
	}
}