<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStationsTable extends Migration {

	public function up()
	{
		Schema::create('stations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('franchisee_id')->unsigned();
			$table->string('name', 250);
			$table->string('calle', 200);
			$table->string('num_ext', 10)->nullable();
			$table->string('num_int', 10);
			$table->string('ciudad', 100);
			$table->integer('id_estado')->unsigned();
			$table->integer('id_pais')->unsigned();
			$table->string('codigo_postal', 7);
			$table->string('telefono', 10)->nullable();
			$table->string('nombre_contacto', 100)->nullable();
			$table->string('apellido_contacto', 100)->nullable();
			$table->string('email_contacto', 100)->nullable();
			$table->integer('telefono_contacto')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stations');
	}
}