<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWashesTable extends Migration {

	public function up()
	{
		Schema::create('washes', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('machine_id')->unsigned();
			$table->bigInteger('client_id')->unsigned();
			$table->char('stop_flag', 1);
			$table->bigInteger('washed_type_id')->unsigned();
			$table->string('trailer_number', 100);
			$table->string('trailer_plates', 100)->nullable();
			$table->integer('level');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->datetime('cancel_date');
			$table->bigInteger('register_user_id')->nullable();
			$table->bigInteger('cancel_user_id');
			$table->string('certificate_number', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('washes');
	}
}