<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatesTable extends Migration {

	public function up()
	{
		Schema::create('states', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('name', 150);
			$table->string('short_name', 10)->nullable();
			$table->string('apha_2', 2)->nullable();
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('states');
	}
}