<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('user_id');
			$table->string('user_username', 200)->index();
			$table->string('user_email', 200)->index();
			$table->string('user_password', 255);
			$table->string('user_fullname', 255)->index();
			$table->string('user_range', 100)->index();
			$table->integer('user_is_active');
			$table->integer('user_profile_id');
			$table->integer('user_cover_photo_id');
			$table->string('user_genre', 50);
			$table->string('user_address', 255);
			$table->text('user_bio');
			$table->integer('user_is_fb_account');
			$table->date('user_birth');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}