<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreLocationsTable extends Migration {

	public function up()
	{
		Schema::create('store_locations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('city_id');
			$table->bigInteger('address_description_id')->unsigned();
			$table->integer('min_order_quantity')->unsigned();
			$table->bigInteger('store_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('store_locations');
	}
}