<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('email', 512)->unique();
			$table->string('password', 512);
			$table->enum('role', array('admin', 'manager', 'driver'));
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}