<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 512)->unique();
			$table->string('password', 512);
			$table->string('google_id', 512);
			$table->string('facebook_id');
			$table->enum('status', array('banned', 'notverified', 'verifired'));
			$table->enum('language', array('en', 'ar'));
			$table->bigInteger('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}