<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreCatalogTable extends Migration {

	public function up()
	{
		Schema::create('store_catalog', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('store_location_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->integer('price')->unsigned();
			$table->enum('is_avalible', array('notavalible', 'instock'));
			$table->integer('min_quantity')->unsigned();
			$table->datetime('change_avalible_at');
		});
	}

	public function down()
	{
		Schema::drop('store_catalog');
	}
}