<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('customer_id')->unsigned();
			$table->enum('status', array('received', 'processing', 'completed'));
			$table->bigInteger('driver_id')->unsigned();
			$table->datetime('processing_at');
			$table->datetime('completed_at');
			$table->text('address');
			$table->bigInteger('city_id')->unsigned();
			$table->integer('shipping_price')->unsigned();
			$table->text('instructions');
			$table->string('phone', 32);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}