<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('title_id')->unsigned();
			$table->bigInteger('subtitle_id')->unsigned();
			$table->bigInteger('picture_id')->nullable();
			$table->string('model', 64);
			$table->bigInteger('description_id')->unsigned();
			$table->bigInteger('category_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}