<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('booking', function(Blueprint $table) {
			$table->foreign('consultationId')->references('id')->on('doctorConsultationInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->foreign('doctorId')->references('id')->on('doctor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('booking', function(Blueprint $table) {
			$table->dropForeign('booking_consultationId_foreign');
		});
		Schema::table('booking', function(Blueprint $table) {
			$table->dropForeign('booking_doctorId_foreign');
		});
	}
}