<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ResolvedForm extends Eloquent {

	protected $table = 'resolved_forms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function form()
	{
		return $this->belongsTo('App\Models\Form');
	}

}