<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_type_id')->references('id')->on('user_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('priority_id')->references('id')->on('priorities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_forms', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_forms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('resolved_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->foreign('resolved_form_id')->references('id')->on('resolved_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->foreign('attachment_type_id')->references('id')->on('attachment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('participant_parties', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('participant_parties', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('form_type_id')->references('id')->on('form_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_type_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_section_id_foreign');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->dropForeign('types_category_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_user_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_type_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_priority_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_area_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_form_id_foreign');
		});
		Schema::table('resolved_forms', function(Blueprint $table) {
			$table->dropForeign('resolved_forms_form_id_foreign');
		});
		Schema::table('resolved_forms', function(Blueprint $table) {
			$table->dropForeign('resolved_forms_user_id_foreign');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->dropForeign('resolved_attachments_resolved_form_id_foreign');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->dropForeign('resolved_attachments_attachment_type_id_foreign');
		});
		Schema::table('participant_parties', function(Blueprint $table) {
			$table->dropForeign('participant_parties_user_id_foreign');
		});
		Schema::table('participant_parties', function(Blueprint $table) {
			$table->dropForeign('participant_parties_type_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_form_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_form_type_id_foreign');
		});
	}
}