<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Form extends Eloquent {

	protected $table = 'forms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('longitude', 'latitude', 'comment');

	public function type()
	{
		return $this->belongsTo('App\Models\Type');
	}

	public function priority()
	{
		return $this->belongsTo('App\Models\Priority');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function area()
	{
		return $this->belongsTo('App\Models\Area');
	}

}