<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = false;

    public function parkspots()
    {
        return $this->hasMany('Parkspot', 'user_id');
    }

    public function partrequests()
    {
        return $this->hasMany('Parkrequest', 'user_id');
    }

    public function reminders()
    {
        return $this->hasOne('Reminder');
    }

    public function activation()
    {
        return $this->hasOne('Activation', 'user_id');
    }

    public function ratings()
    {
        return $this->hasMany('Rating', 'user_id');
    }

}