<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParkrequestsTable extends Migration {

	public function up()
	{
		Schema::create('parkrequests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('parkspot_id')->unsigned();
			$table->date('date');
			$table->enum('part', array('day', 'morning', 'afternoon'));
			$table->boolean('accepted')->default(0);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('parkrequests');
	}
}