<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParkspotsTable extends Migration {

	public function up()
	{
		Schema::create('parkspots', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('street');
			$table->string('plz');
			$table->string('city');
			$table->string('type');
			$table->string('available_on');
			$table->boolean('active')->default(1);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('parkspots');
	}
}