<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Fund extends Model 
{

    protected $table = 'fund';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'active');

    public function fund_accounts()
    {
        return $this->hasMany('FundAccount', 'fund_id');
    }

}