<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFundTable extends Migration {

	public function up()
	{
		Schema::create('fund', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->boolean('active')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('fund');
	}
}