<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientFundHistory extends Model 
{

    protected $table = 'client_fund_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'client_fund_id', 'credit_before', 'credit_after', 'amount_add', 'amount_deduct', 'details', 'type', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client_fund()
    {
        return $this->belongsTo('ClientFund', 'client_fund_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}