<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContainerItem extends Model 
{

    protected $table = 'container_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('container_client_id', 'type', 'length', 'width', 'height', 'quantity', 'coeffecient', 'volume', 'price');

    public function container_client()
    {
        return $this->belongsTo('ContainerClient', 'cotainer_client_id');
    }

}