<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateViewsTable extends Migration {

	public function up()
	{
		Schema::create('views', function(Blueprint $table) {
			$table->increments('id');
			$table->nullableMorphs('viewer');
			$table->morphs('viewable');
			$table->bigInteger('views_count')->default('1');
			$table->timestamp('first_viewed_at');
			$table->timestamp('last_viewed_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('views');
	}
}