<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function countacts()
	{
		return $this->belongsToMany('ContactGroup');
	}

	public function wishlistCategories()
	{
		return $this->belongsToMany('WishlistCategoryGroup');
	}

}