<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function likes()
    {
        return $this->morphToMany('Likek');
    }

    public function targetGroups()
    {
        return $this->hasMany('PostTargetGroup');
    }

    public function groupExclusions()
    {
        return $this->belongsToMany('PostTargetGroupExclusion', 'post_id');
    }

    public function attachments()
    {
        return $this->morphMany('Attachment');
    }

    public function views()
    {
        return $this->morphMany('View');
    }

    public function comments()
    {
        return $this->morphMany('Comment');
    }

    public function ratings()
    {
        return $this->hasMany('PostRating');
    }

}