<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTargetGroupsTable extends Migration {

	public function up()
	{
		Schema::create('post_target_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('post_id')->unsigned();
			$table->bigInteger('group_id')->unsigned();
			$table->enum('mode', array('include_all', 'exclude_some'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post_target_groups');
	}
}