<?php

namespace App\Models;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('name', 'hospital_name', 'city_id', 'phone', 'age', 'blood_type_id', 'bags_num', 'hospital_address', 'details', 'latitude', 'longitude');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function blood_types()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}