<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'date_of_birth', 'last_donation_date', 'pin_code', 'blood_type_id', 'city_id');

	public function blood_type()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function blood_types()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function governorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function tokens()
	{
		return $this->hasMany('App\Models\Token');
	}

}