<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('sku')->unique();
			$table->string('name');
			$table->text('description');
			$table->string('tags');
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('brand_id')->unsigned();
			$table->string('unit')->nullable();
			$table->boolean('refundable')->default(0);
			$table->boolean('free_shipping')->default(0);
			$table->integer('low_stock_quantity')->default('1');
			$table->boolean('show_stock_quantity')->default(0);
			$table->boolean('cash_on_delivery')->default(0);
			$table->boolean('todays_deal')->default(0);
			$table->integer('estimate_shipping')->nullable();
			$table->double('tax')->nullable();
			$table->double('discount')->default('0');
			$table->integer('quantity');
			$table->string('meta_title')->nullable();
			$table->text('meta_description')->nullable();
			$table->boolean('available')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}