<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('address_1');
			$table->string('address_2')->nullable();
			$table->string('state_code');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}