<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->timestamps();
			$table->string('rate')->nullable();
			$table->bigInteger('order_id')->unsigned();
			$table->string('rate_comment')->nullable();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}