<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->bigInteger('parent_id')->unsigned();
			$table->boolean('status')->default(0);
			$table->boolean('show_in_navbar')->default(0);
			$table->string('url');
			$table->integer('sort')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}