<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('coupon_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('address_id')->unsigned();
			$table->decimal('tax_percentage')->nullable();
			$table->tinyInteger('type')->default('0');
			$table->tinyInteger('payment');
			$table->decimal('total_cost');
			$table->bigInteger('order_status_id')->unsigned();
			$table->decimal('total_products');
			$table->string('reference')->unique();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}