<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->nullable();
			$table->text('content');
			$table->text('image')->nullable();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}