<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentsTable extends Migration {

	public function up()
	{
		Schema::create('shipments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('status')->nullable();
			$table->integer('total_qty')->nullable();
			$table->integer('total_weight')->nullable();
			$table->string('carrier_code')->nullable();
			$table->string('carrier_title')->nullable();
			$table->text('track_number')->nullable();
			$table->boolean('email_sent')->default(0);
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('order_address_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shipments');
	}
}