<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('image', 255);
			$table->boolean('active')->default(1);
			$table->bigInteger('parent_id')->unsigned();
			$table->bigInteger('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}