<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('restaurant_id')->unsigned();
			$table->string('name', 255);
			$table->string('lastname', 255)->nullable();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->enum('role', array('owner', 'admin'));
			$table->string('image', 255);
			$table->timestamp('verified_at');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}