<?php

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	public function table_id()
	{
		return $this->belongsTo('Table', 'table_id');
	}

	public function plates()
	{
		return $this->belongsToMany('Plate')->withPivot('amount', 'comment');
	}

	public function restaurant()
	{
		return $this->belongsTo('Restaurant', 'restaurant_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}