<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorPackageAddedTable extends Migration {

	public function up()
	{
		Schema::create('vendor_package_added', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('master_id')->unsigned();
			$table->string('name', 50);
			$table->string('description', 100);
			$table->float('price', 8,2);
			$table->integer('vendor_role');
			$table->char('state', 3);
			$table->boolean('package_type');
			$table->integer('ordering');
			$table->string('icon', 150);
			$table->integer('simulated_by');
			$table->datetime('simulated_at');
			$table->tinyInteger('status');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamp('deleted_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendor_package_added');
	}
}