<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'surname');

    public function bilhetes()
    {
        return $this->hasMany('Bilhete');
    }

    public function comentarios()
    {
        return $this->hasMany('Comentario');
    }

    public function paginas()
    {
        return $this->hasMany('Pagina');
    }

    public function artigos()
    {
        return $this->hasMany('Artigo');
    }

    public function categorias()
    {
        return $this->hasMany('Categoria');
    }

    public function pagamentos()
    {
        return $this->hasMany('Pagamento');
    }

    public function menus()
    {
        return $this->hasMany('Menu');
    }

}