<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('comentarios', function(Blueprint $table) {
			$table->foreign('artigo_id')->references('id')->on('artigos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comentarios', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categorias')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('bilhetes', function(Blueprint $table) {
			$table->foreign('pagamento_id')->references('id')->on('pagamentos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bilhetes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categorias')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pagamentos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('comentarios', function(Blueprint $table) {
			$table->dropForeign('comentarios_artigo_id_foreign');
		});
		Schema::table('comentarios', function(Blueprint $table) {
			$table->dropForeign('comentarios_user_id_foreign');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->dropForeign('artigos_user_id_foreign');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->dropForeign('artigos_menu_id_foreign');
		});
		Schema::table('artigos', function(Blueprint $table) {
			$table->dropForeign('artigos_categoria_id_foreign');
		});
		Schema::table('bilhetes', function(Blueprint $table) {
			$table->dropForeign('bilhetes_pagamento_id_foreign');
		});
		Schema::table('bilhetes', function(Blueprint $table) {
			$table->dropForeign('bilhetes_user_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_user_id_foreign');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->dropForeign('paginas_user_id_foreign');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->dropForeign('paginas_menu_id_foreign');
		});
		Schema::table('paginas', function(Blueprint $table) {
			$table->dropForeign('paginas_categoria_id_foreign');
		});
		Schema::table('pagamentos', function(Blueprint $table) {
			$table->dropForeign('pagamentos_user_id_foreign');
		});
	}
}