<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacanteTable extends Migration {

	public function up()
	{
		Schema::create('vacante', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('fechaPublicacion');
			$table->integer('id_cargo')->unsigned();
			$table->string('descripcion', 255);
			$table->integer('anioExperiencia')->default('0');
			$table->datetime('fechaCierre');
			$table->decimal('salario', 10,2)->default('0');
			$table->integer('cantidad')->default('1');
			$table->integer('id_tipoContratacion')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('vacante');
	}
}