<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInvestment extends Model 
{

    protected $table = 'acc_investment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'currency_id', 'control_account_id', 'code', 'name_en', 'name_ar', 'market_price', 'quantity', 'total_cost', 'status', 'average_cost', 'market_value', 'unrealized_gain');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function investment_revaluations()
    {
        return $this->belongsToMany('AccInvestmentRevaluation', 'investment_id', 'investment_revaluation_id', 'investment_revaluation_item_id');
    }

}